//
//  QGLModelOverlayViewController.m
//  QMapKitDemo
//
//  Created by Keith Cao on 2023/10/24.
//  Copyright © 2023 tencent. All rights reserved.
//

#import "QGLModelOverlayViewController.h"
#import <QMapVisualPlugin/QModelOverlayView.h>

@interface QGLModelOverlayViewController () <QGLOverlayDelegate>

@property (nonatomic, strong) QModelOverlay *model;

@end

@implementation QGLModelOverlayViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
	
	self.mapView.centerCoordinate = CLLocationCoordinate2DMake(40.025624,116.392369);
	[self setUpUIBarItem];
	[self createModelOverlay];
}

- (void)createModelOverlay
{
	
	NSString *gltfPath = @"xxx/xxx.gltf";		///gltf后缀文件路径
	NSString *path = [[NSBundle mainBundle] pathForResource:gltfPath ofType:nil];
	
	self.model = [[QModelOverlay alloc] init];
	self.model.path = path;
	self.model.coordinate = self.mapView.centerCoordinate;
	
	// 地理大小（大小随地图缩放变化）
	{
		QGLOverlayGeoRenderMode *geoMode = [[QGLOverlayGeoRenderMode alloc] init];
		geoMode.scale = 1;
		self.model.renderMode = geoMode;
	}
	
	// 屏幕像素大小，模型大小固定
	{
		QGLOverlayPixelRenderMode *pxMode = [[QGLOverlayPixelRenderMode alloc] init];
		pxMode.size = CGSizeMake(100, 100);
		self.model.renderMode = pxMode;
	}
	
	// 可调整模型的X、Y、Z轴
	self.model.rotationX = 90;
	
	self.model.delegate = self;
	
	[self.mapView addOverlay:self.model];
}

- (void)playModelSkeletonAnimation
{
	NSArray <QModelAnimationInfo *> *animations = [self.model getAnimationInformation];
	
	for (QModelAnimationInfo *info in animations)
	{
		NSLog(@"ModelOverlay animationInfo name:%@, 动画标识:%lu, 时长:%f", info.name, info.index, info.duration);
	}
	
	QModelAnimationInfo *fisrtAni = animations.firstObject;
	
	[self.model playAnimationWithIndex:(int)fisrtAni.index speed:1 autoRepeat:YES];
}

- (void)handleTestAction
{
	[self.model stopAnimation];
}

- (void)handleUpdate
{
	self.model.rotationX = arc4random() % 360;
	self.model.unlit = !self.model.unlit;
	// 更新模型属性需调用 setNeedsDisplay
	[self.model setNeedsDisplay];
}

#pragma mark - MapDelegate

- (QOverlayView *)mapView:(QMapView *)mapView viewForOverlay:(id<QOverlay>)overlay
{
	if ([overlay isKindOfClass:[QModelOverlay class]])
	{
		QModelOverlayView *render = [[QModelOverlayView alloc] initWithOverlay:overlay];
		
		return render;
	}
	
	return nil;
}

#pragma mark -- ModelOverlay Delegate

- (void)glOverlay:(QGLOverlay *)overlay loadStatus:(QGLOverlayLoadStatus)status withProgress:(CGFloat)progress
{
	NSLog(@"%s , Modeloverlay LoadStatus:%lu, progress:%f", __FUNCTION__, status, progress);
	
	if (status == QGLOverlayLoadSuccess)
	{
		[self playModelSkeletonAnimation];
	}
}

#pragma mark -- UI

- (void)setUpUIBarItem
{
	UIBarButtonItem *testItem0 = [[UIBarButtonItem alloc] initWithTitle:@"停止动画"
																  style:UIBarButtonItemStylePlain
																 target:self
																 action:@selector(handleTestAction)];
	
	UIBarButtonItem *testItem1 = [[UIBarButtonItem alloc] initWithTitle:@"更新样式"
																  style:UIBarButtonItemStylePlain
																 target:self
																 action:@selector(handleUpdate)];
	
	self.navigationItem.rightBarButtonItems = @[testItem0, testItem1];
}

@end
